# 1Password Administrative Templates (ADMX/ADML)

**Namespace:** Agilebits.Policies.1Password

---

## Supported Platforms

- Supported 1Password versions: **8.12.4-46 and later**
- Supported Windows versions: **Windows 10 and later**
- Supported architectures: x64 / ARM64
- Supported languages: en-US

---

## Installation / Deployment Instructions

### Local Install (Single Machine)

1. Copy `1Password.admx` to `%SystemRoot%\PolicyDefinitions\`.
2. Copy `en-US\1Password.adml` into `%SystemRoot%\PolicyDefinitions\en-US\`.
3. Open Group Policy Editor (gpedit.msc). Ensure the template appears under Administrative Templates → 1Password in both Computer Configuration and User Configuration.

### Domain / Central Store (Active Directory)

1. On a domain controller, navigate to `\\<domain>\SYSVOL\<domain>\Policies\PolicyDefinitions\`
2. Copy `1Password.admx` to that directory.
3. Copy the language ADML file into the corresponding subfolder under `PolicyDefinitions` (e.g. `en-US\`).
4. Refresh GPMC (Group Policy Management Console) — the templates should now be visible for all domain controllers.

### Microsoft Intune / ADMX Ingestion

The 1Password ADMX templates have no external dependencies, so it can be imported directly into the Microsoft Intune Admin Center.

For detailed instructions, see [Import custom ADMX and ADML files in Intune](https://learn.microsoft.com/en-us/intune/intune-service/configuration/administrative-templates-import-custom#add-the-admx-and-adml-files).

---

## Usage & Policy Descriptions

ADMX templates can be used to configure and manage many app settings and features. These templates support both per-user (user groups) and per-machine (device groups) deployment. In environments where both apply, user-scope settings take priority over machine-scope settings.

Many 1Password policy description fields include a reference key (for example, `Reference: app.openAppOnStartup`) which corresponds to the registry or policy name. You can use this key to look up the description on the [1Password Mobile Device Management support page](https://support.1password.com/mobile-device-management/?windows). Note: not every policy appears there — some may be newly introduced, not yet broadly documented, or not currently applicable. To view a full list of policies, ensure you are using the latest version of the administrative templates generated with the most recent 1Password release. Only use templates from stable 1Password releases in production; avoid using templates generated against versions below the minimum supported version outlined at the top of this document.

##### Managed Install

This is a critical policy: if it is not configured, all other ADMX-based policies will be ignored. The `Managed Install` policy identifies which 1Password installation instance is managed. If a user has multiple instances of 1Password, launching an unmanaged version will redirect to the managed one, and the unmanaged version may be silently removed. This setting also determines which installation subsequent policy settings will apply to.

For MSI installations, the `MANAGED_INSTALL` install flag will also register the installation as managed.

**Note:** This policy has no effect in per-user scope for MSI deployments. Additionally, enabling this policy does not prevent users from manually removing the managed instance.

##### Auto Update

This policy inside the `Updates` category controls whether 1Password is allowed to perform in-app updates. When disabled, in-app updates are disabled — 1Password can only update when the administrator deploys a new version. This is especially useful when:

- You need version control and consistency across all users/devices.

- Users do not have administrative rights to install MSI updates.

- MSIX deployments as a Line-of-Business (LOB) via Microsoft Intune may lose detection if the app updates itself outside of Intune’s control.

For MSI installations, the `MANAGED_UPDATE` install flag will also register updates as managed.

**Note:** This policy should be applied at machine-scope (HKLM), rather than user-scope (HKCU) for version control and consistency across all users and devices. The `Managed Install` policy must be configured for this policy to take effect. Additionally, disabling this policy does not prevent users from manually updating the managed instance. It also does not prevent updates through Windows for Microsoft Store and App Installer deployments.

---

## Updating ADMX Templates

Each release of the ADMX/ADML template package is automatically generated. The version number defined at the top of this document corresponds to the 1Password build tag for that release. Because the README and template files are generated, a changelog is not maintained here.

We recommend that IT administrators review and update the 1Password ADMX/ADML template package as part of their scheduled maintenance cycle. A review every six months is a good guideline. Consider updating when new settings are introduced or an existing setting is deprecated.

The namespace used for the ADMX templates is defined at the top of this document. Note that in Microsoft Intune, uploading a new ADMX file with the same namespace will fail unless you either:

1. First delete the profiles and template that use the existing namespace, or

2. Manually change the namespace in the new ADMX file before uploading it.

See [Replacing existing ADMX templates in Intune](https://learn.microsoft.com/en-us/intune/intune-service/configuration/administrative-templates-import-custom#replace-existing-admx-files) for more information. Before applying any template update, we recommend you:

1. Back up your current ADMX/ADML files and any associated configuration profiles.

2. Test the new templates in a pilot group before full deployment.

3. Verify that both new and existing settings have been applied, and that no unexpected side-effects occurred.

## Migration & Backward Compatibility

With 1Password administrative templates, policy settings can deploy either per-user or per-machine. The corresponding registry paths are:

- `HKCU:\Software\Policies\Agilebits Inc.\1Password` (per-user)

- `HKLM:\Software\Policies\Agilebits Inc.\1Password` (per-machine)

The legacy registry path for managing settings (`HKLM:\Software\Agilebits Inc.\1Password\Policy`) will eventually be phased out. During the transition period, 1Password will continue to detect settings applied at that legacy path. The order of precedence when reading settings is:

1. `HKCU:\Software\Policies\Agilebits Inc.\1Password`

2. `HKLM:\Software\Policies\Agilebits Inc.\1Password`

3. `HKLM:\Software\Agilebits Inc.\1Password\Policy` (legacy)

We recommend adopting the ADMX templates fully and migrating any existing configurations, then removing the legacy registry key once you’ve validated functionality.

MSI installations that use the `MANAGED_INSTALL` and `MANAGED_UPDATE` install flags will remain supported, but 1Password will treat both as lower priority than the `Managed Install` and `Auto Update` policies if configured. If you plan to migrate from MSI-install flags to the new policy settings, the recommended sequence is:

1. Configure the `Managed Install` and `Auto Update` policies via ADMX.

2. Remove the `MANAGED_INSTALL` and `MANAGED_UPDATE` flags (e.g., via removing and re-deploying the MSI without them).

3. Validate that the policies are applied and functioning as expected before rolling out broadly to production.
